unit NetworkDemoMainForm;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls,
  FMX.Controls.Presentation;

type
  TfrmMain = class(TForm)
    chkConnected: TCheckBox;
    chkWifiConnected: TCheckBox;
    chkMobileConnected: TCheckBox;
    Label1: TLabel;
    tmrConnection: TTimer;
    chkRoaming: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure tmrConnectionTimer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.fmx}

uses
  Androidapi.Network;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  tmrConnection.OnTimer(tmrConnection);
  tmrConnection.Enabled := True;
end;

procedure TfrmMain.tmrConnectionTimer(Sender: TObject);
begin
  chkConnected.IsChecked := IsConnected;
  chkRoaming.IsChecked := IsRoaming;
  chkWifiConnected.IsChecked := IsWiFiConnected;
  if chkWifiConnected.IsChecked then
    chkWifiConnected.Text := 'Wi-Fi Connected: ' + WiFiSSID
  else
    chkWifiConnected.Text := 'Wi-Fi Connected';
  chkMobileConnected.IsChecked := IsMobileConnected;
end;

end.
